<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Template Drops with Constraints Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis vložených šablon a vazeb</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Výpis vložených šablon a vazeb</h2>
                                <p lang="en">
                                    Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                    Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- Roadway Designer Data -->
                            <xsl:for-each select="RoadwayDesigner">
                                <table class="margin" cellpadding="2">
                                    <tbody>
                                        <tr>
                                            <th align="right" lang="en">Název souboru:&#xa0; </th>
                                            <td align="left"><xsl:value-of select="@fileName"/></td>
                                        </tr>
                                    </tbody>
                                </table>
                                <hr/>
                                <!-- Corridor Information -->
                                <table style="font-size: 90%" width="100%">
                                    <xsl:for-each select="Corridor">
                                        <tr>
                                            <td><strong>Koridor:&#xa0; </strong><xsl:value-of select="@name"/></td>
                                        </tr>
                                        <tr style="line-height:75%"><td><hr size="1"/></td></tr>
                                        <tr>
                                            <td>
                                                <table class="margin" style="font-size: 90%" width="95%">
                                                    <xsl:for-each select="TemplateDrop/Template">
                                                        <tr>
                                                            <td lang="en">
                                                                <strong>Šablona:&#xa0; </strong><xsl:value-of select="@name"/>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td lang="en">
                                                                <strong>Staničení Začátek:&#xa0; </strong>
                                                                <xsl:value-of select="cif:stationFormat(number(../StartStation/@externalStation), string(../StartStation/@externalStationName))"/>
                                                                <strong>Staničení Konec:&#xa0; </strong>
                                                                <xsl:value-of select="cif:stationFormat(number(../StopStation/@externalStation), string(../StopStation/@externalStationName))"/>
                                                                <strong>&#xa0; &#xa0; Interval:&#xa0; </strong>
                                                                <xsl:value-of select="cif:distanceFormat(number(../@interval))"/>
                                                            </td>
                                                        </tr>
                                                        <tr style="line-height:75%"><td><hr size="1"/></td></tr>
                                                        <tr>
                                                            <td>
                                                                <table class="margin" style="font-size: 90%" width="95%">
                                                                    <colgroup span="9">
                                                                        <col width="19%"/>
                                                                        <col width="7%"/>
                                                                        <col width="7%"/>
                                                                        <col width="12%"/>
                                                                        <col width="11%"/>
                                                                        <col width="19%"/>
                                                                        <col width="11%"/>
                                                                        <col width="7%"/>
                                                                        <col width="7%"/>
                                                                    </colgroup>
                                                                    <xsl:for-each select="Components/Component">
                                                                        <tr>
                                                                            <td colspan="9" lang="en">
                                                                                <strong>Komponenta:&#xa0; </strong>
                                                                                <xsl:value-of select="@name"/>
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <td colspan="9" lang="en">
                                                                                <strong>Popis:&#xa0; </strong>
                                                                                <xsl:value-of select="@description"/>
                                                                            </td>
                                                                        </tr>
                                                                        <tr>
                                                                            <th class="underline" align="left" lang="en" rowspan="2" valign="bottom">
                                                                                Název bodu
                                                                            </th>
                                                                            <th class="underline" lang="en" rowspan="2" valign="bottom">
                                                                                X
                                                                            </th>
                                                                            <th class="underline" lang="en" rowspan="2" valign="bottom">
                                                                                Y
                                                                            </th>
                                                                            <th colspan="3" lang="en" valign="bottom">
                                                                                - - - - Vazby - - - -
                                                                            </th>
                                                                            <th class="underline" lang="en" rowspan="2" valign="bottom">
                                                                                Sklon
                                                                            </th>
                                                                            <th class="underline" lang="en" rowspan="2" valign="bottom">
                                                                                Šířka
                                                                            </th>
                                                                            <th class="underline" lang="en" rowspan="2" valign="bottom">
                                                                                Delta Y
                                                                            </th>
                                                                        </tr>
                                                                        <tr>
                                                                            <th class="underline" lang="en" valign="bottom">Typ</th>
                                                                            <th class="underline" lang="en" valign="bottom">Hodnota</th>
                                                                            <th class="underline" lang="en" valign="bottom">Rodič</th>
                                                                        </tr>
                                                                        <xsl:for-each select="Vertex">
                                                                            <xsl:variable name="nextPoint" select="following-sibling::*[1]/@name"/>
                                                                            <xsl:variable name="width" select="../../../Points/Point[@name = $nextPoint]/@x - ../../../Points/Point[@name = current()/@name]/@x"/>
                                                                            <xsl:variable name="depth" select="../../../Points/Point[@name = $nextPoint]/@y - ../../../Points/Point[@name = current()/@name]/@y"/>
                                                                            <tr>
                                                                                <td><xsl:value-of select="@name"/></td>
                                                                                <td class="sidepad" align="right">
                                                                                    <xsl:value-of select="cif:distanceFormat(number(../../../Points/Point[@name = current()/@name]/@x))"/>
                                                                                </td>
                                                                                <td class="sidepad" align="right">
                                                                                    <xsl:value-of select="cif:distanceFormat(number(../../../Points/Point[@name = current()/@name]/@y))"/>
                                                                                </td>
                                                                                <td class="sidepad">
                                                                                    <xsl:value-of select="../../../Points/Point[@name = current()/@name]/Constraint[1]/@type"/><br/>
                                                                                    <xsl:value-of select="../../../Points/Point[@name = current()/@name]/Constraint[2]/@type"/>
                                                                                </td>
                                                                                <td class="sidepad" align="right">
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="../../../Points/Point[@name = current()/@name]/Constraint[1]/@type = 'Slope'">
                                                                                            <xsl:value-of select="cif:gradeFormat(number(../../../Points/Point[@name = current()/@name]/Constraint[1]/@value))"/><br/>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="../../../Points/Point[@name = current()/@name]/Constraint[1]/@type = 'None'">
                                                                                            &#xa0;<br/>&#xa0;
                                                                                        </xsl:when>
                                                                                        <xsl:otherwise>
                                                                                            <xsl:value-of select="cif:distanceFormat(number(../../../Points/Point[@name = current()/@name]/Constraint[1]/@value))"/><br/>
                                                                                        </xsl:otherwise>
                                                                                    </xsl:choose>
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="../../../Points/Point[@name = current()/@name]/Constraint[2]/@type = 'Slope'">
                                                                                            <xsl:value-of select="cif:gradeFormat(number(../../../Points/Point[@name = current()/@name]/Constraint[2]/@value))"/>
                                                                                        </xsl:when>
                                                                                        <xsl:when test="../../../Points/Point[@name = current()/@name]/Constraint[1]/@type = 'None'">
                                                                                            &#xa0;<br/>&#xa0;
                                                                                        </xsl:when>
                                                                                        <xsl:otherwise>
                                                                                            <xsl:value-of select="cif:distanceFormat(number(../../../Points/Point[@name = current()/@name]/Constraint[1]/@value))"/><br/>
                                                                                        </xsl:otherwise>
                                                                                    </xsl:choose>
                                                                                </td>
                                                                                <td>
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="../../../Points/Point[@name = current()/@name]/Constraint[1]/@parent">
                                                                                            <xsl:value-of select="../../../Points/Point[@name = current()/@name]/Constraint[1]/@parent"/><br/>
                                                                                        </xsl:when>
                                                                                        <xsl:otherwise>&#xa0;<br/></xsl:otherwise>
                                                                                    </xsl:choose>
                                                                                    <xsl:choose>
                                                                                        <xsl:when test="../../../Points/Point[@name = current()/@name]/Constraint[2]/@parent">
                                                                                            <xsl:value-of select="../../../Points/Point[@name = current()/@name]/Constraint[2]/@parent"/>
                                                                                        </xsl:when>
                                                                                        <xsl:otherwise>&#xa0;</xsl:otherwise>
                                                                                    </xsl:choose>
                                                                                </td>
                                                                            </tr>
                                                                            <xsl:choose>
                                                                                <xsl:when test="position() != last()">
                                                                                    <tr>
                                                                                        <td colspan="6">&#xa0;</td>
                                                                                        <td class="sidepad" align="right">
                                                                                            <xsl:value-of select="cif:gradeFormat(number($depth div $width))"/>
                                                                                        </td>
                                                                                        <td class="sidepad" align="right">
                                                                                            <xsl:value-of select="cif:distanceFormat(number($width))"/>
                                                                                        </td>
                                                                                        <td class="sidepad" align="right">
                                                                                            <xsl:value-of select="cif:distanceFormat(number($depth))"/>
                                                                                        </td>
                                                                                    </tr>
                                                                                </xsl:when>
                                                                                <xsl:otherwise>
                                                                                    <xsl:variable name="firstPoint" select="preceding-sibling::*[last()]/@name"/>
                                                                                    <xsl:variable name="finalWidth" select="../../../Points/Point[@name = $firstPoint]/@x - ../../../Points/Point[@name = current()/@name]/@x"/>
                                                                                    <xsl:variable name="finalDepth" select="../../../Points/Point[@name = $firstPoint]/@y - ../../../Points/Point[@name = current()/@name]/@y"/>
                                                                                    <xsl:if test="../@isClosed = 'true'">
                                                                                        <tr>
                                                                                            <td colspan="6">&#xa0;</td>
                                                                                            <td class="sidepad" align="right">
                                                                                                <xsl:value-of select="cif:gradeFormat(number($finalDepth div $finalWidth))"/>
                                                                                            </td>
                                                                                            <td class="sidepad" align="right">
                                                                                                <xsl:value-of select="cif:distanceFormat(number($finalWidth))"/>
                                                                                            </td>
                                                                                            <td class="sidepad" align="right">
                                                                                                <xsl:value-of select="cif:distanceFormat(number($finalDepth))"/>
                                                                                            </td>
                                                                                        </tr>
                                                                                    </xsl:if>
                                                                                </xsl:otherwise>
                                                                            </xsl:choose>
                                                                        </xsl:for-each>
                                                                        <tr style="line-height:75%"><td colspan="9">&#xa0;</td></tr>
                                                                    </xsl:for-each>
                                                                </table>
                                                            </td>
                                                        </tr>
                                                    </xsl:for-each>
                                                </table>
                                            </td>
                                        </tr>
                                        <tr><td>&#xa0;</td></tr>
                                    </xsl:for-each>
                                </table>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
                Pro tento výpis musíte vybrat koridor s minimálně jednou vloženou šablonou.
            </p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
</xsl:stylesheet>
